#ifndef _SQLTEMPLATE_CPP
#define _SQLTEMPLATE_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "NSWFL.H"
#include "SQLTemplate.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ReplStr(char *sBuf, const char *sReplace, const char *sWith)
{
	char *sReplBuf = NULL;
	int iBufSz = strlen(sBuf);
	int iPos = 0;
	int iOccurrences  = 0; // The number of time "sReplace" occurs in "sBuf".
	int iMemRequired = 0;
	int iMemDiff = strlen(sWith) - strlen(sReplace);

	while( (iPos = InStrEx(sReplace, sBuf, iBufSz, iPos)) > 0)
	{
		iPos++;
		iOccurrences++;
	}

	if(iOccurrences == 0)
	{
		return 0;
	}

	iMemRequired = (iBufSz + (iMemDiff * iOccurrences)) + 1;

	sReplBuf = (char *) calloc(sizeof(char), iMemRequired);

	ReplaceStrings(sBuf, sReplace, sWith, sReplBuf);
	memcpy(sBuf, sReplBuf, iMemRequired);
	free(sReplBuf);

	return iOccurrences;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool BuildSQLFromTemplate(const char *sScriptPath, const char *sFile, char *sSQL, LPSQLTEMPLATE lpSQLTemp)
{
	FILE *hSource = NULL;
	char sFilePath[MAX_PATH];
	int iLen = 0;

	sprintf(sFilePath, "%s\\SQL\\%s", sScriptPath, sFile);
	if((hSource = fopen(sFilePath, "rb")) == NULL)
	{
		MessageBox(GetActiveWindow(), "Failed to open the SQL Template file.", "BuildSQLFromTemplate", 0);
		return false;
	}

	iLen = Get_FileSize(sFilePath);
	fread(sSQL, iLen, sizeof(char), hSource);
	sSQL[iLen] = '\0';

	fclose(hSource);

	if(lpSQLTemp != NULL)
	{
		if(lpSQLTemp->iMask &SQLTMP_DB)    ReplStr(sSQL, "{SQLExch_TAG_DB}", lpSQLTemp->sDB);
		if(lpSQLTemp->iMask &SQLTMP_TABLE) ReplStr(sSQL, "{SQLExch_TAG_TABLE}", lpSQLTemp->sTable);
		if(lpSQLTemp->iMask &SQLTMP_DBDIR) ReplStr(sSQL, "{SQLExch_TAG_DBDIR}", lpSQLTemp->sDBDir);
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif